/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.reward;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.quests.reward.IQuestRewardResolver;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public final class RewardProviderType {
    private static final Map<ResourceLocation, RewardProviderType> MAP = new HashMap<ResourceLocation, RewardProviderType>();
    private final ResourceLocation id;
    private final IQuestRewardResolver resolver;

    public RewardProviderType(ResourceLocation id, IQuestRewardResolver resolver) {
        this.id = id;
        this.resolver = resolver;
        MAP.put(id, this);
    }

    RewardProviderType(String id, IQuestRewardResolver resolver) {
        this(GunsRPG.makeResource(id), resolver);
    }

    public IQuestRewardResolver getResolver() {
        return this.resolver;
    }

    public static RewardProviderType getById(ResourceLocation id) {
        return MAP.get(id);
    }

    static {
        new RewardProviderType("item", (IQuestRewardResolver)new IQuestRewardResolver.SingleItem());
        new RewardProviderType("item_list", (IQuestRewardResolver)new IQuestRewardResolver.ItemList());
        new RewardProviderType("item_group", (IQuestRewardResolver)new IQuestRewardResolver.ItemGroup());
    }
}

